"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.Utils = void 0;
var Utils;
(function (Utils) {
    function findOrthographicCamera(sceneObject) {
        if (!sceneObject) {
            return null;
        }
        const cameraComponent = sceneObject.getComponent('Component.Camera');
        if (cameraComponent && cameraComponent.type == Camera.Type.Orthographic) {
            return sceneObject;
        }
        if (sceneObject.getParent()) {
            return findOrthographicCamera(sceneObject.getParent());
        }
        return null;
    }
    Utils.findOrthographicCamera = findOrthographicCamera;
})(Utils = exports.Utils || (exports.Utils = {}));
